/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_issend.c,v 1.57 2006/08/31 19:24:13 bgoglin Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__request.h"
#include "mx_pin.h"
#include "mx__segment.h"
#include "mx__lib.h"
#include "mx__self.h"
#include "mx__shmem.h"
#include "mx__error.h"
#include "mx__endpoint.h"

MX_FUNC(mx_return_t)
#ifndef MX_KERNEL
mx_issend(mx_endpoint_t ep,
	  mx_segment_t *segments_list, uint32_t segments_count,
	  mx_endpoint_addr_t dest_address, uint64_t match_info,
	  void *context, mx_request_t *request)
#else
mx_kissend(mx_endpoint_t ep,
	  mx_segment_t *segments_list, uint32_t segments_count,
	  mx_pin_type_t pin_type,
	  mx_endpoint_addr_t dest_address, uint64_t match_info,
	  void *context, mx_request_t *request)
#endif
{
  union mx_request *q;
  uint32_t length;
  mx_return_t ret_val;
#ifndef MX_KERNEL
  mx_pin_type_t pin_type = MX_PIN_UNDEFINED;
#endif
  struct mx__partner * partner;

  if (segments_count > MX_MAX_SEGMENTS) {
    ret_val = MX_BAD_SEG_CNT;
    goto abort_without_lock;
  }

  ret_val = MX_SUCCESS;
  MX__MUTEX_LOCK(&ep->lock);
  q = mx__rl_alloc(ep);
  if (q == NULL) {
    ret_val = MX_NO_RESOURCES;
    goto abort_with_lock;
  }

  MX__CACHE_SEGMENTS(q->send, segments_list, segments_count);
  if ((q->send.count > 1) && (q->send.segments == NULL)) {
    ret_val = MX_NO_RESOURCES;
    goto abort_with_request;
  }
#ifndef MX_KERNEL
  if (MX_DEBUG_CSUM && mx__opt.csum) {
    mx_always_assert(match_info >> 48 == 0);
    if (q->send.count)
      match_info |= 
	(uint64_t)mx_checksum(q->send.segments[0].segment_ptr, 
			      q->send.segments[0].segment_length) << 48;
  }
#if MX_ONE_SIDED
  mx_always_assert(!(match_info & MX__ONESIDED_MASK));
#endif
#endif
  q->send.memory_context = pin_type;

  partner = mx__partner_from_addr(&dest_address);
  q->basic.partner = partner;
  q->send.basic.status.source = dest_address;
  q->send.basic.status.match_info = match_info;
  q->send.basic.status.context = context;
#if MX_DEBUG
  q->send.basic.status.xfer_length = -1;
#endif
  q->send.basic.mcp_handle = -1;
  q->basic.requeued = 0;
  length = mx__total_segment_length(q->send.segments, q->send.count);
  q->send.basic.status.msg_length = length;
  q->send.basic.type = MX__REQUEST_TYPE_SEND_LARGE;
  q->send.basic.wq = NULL;
  q->send.basic.acquired_by_wait_any = 0;

  MX__EP_STATS_INC(ep, issend);

#ifndef MX_KERNEL
  if (partner == ep->myself && !mx__opt.disable_self) {
    mx__self_send(ep, q);
  } else
#endif
#if MX_USE_SHMEM
    if (partner->peer_index_n == ep->myself->peer_index_n &&
	!mx__opt.disable_shmem) {
    mx__shm_send(ep,q);
  } else
#endif
   {
    q->send.basic.state = MX__REQUEST_STATE_SEND_QUEUED;
    mx__enqueue_request(&ep->send_reqq, q);
  }

  mx__luigi(ep);

  *request = q;
  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;

 abort_with_request:
  mx__rl_free(ep, q);
 abort_with_lock:
  MX__MUTEX_UNLOCK(&ep->lock);
 abort_without_lock:
  return mx__error(ep, "mx_issend", ret_val);
}

